<?php
add_theme_support( 'custom-logo' );

// Add default posts and comments RSS feed links to head.
add_theme_support( 'automatic-feed-links' );

add_theme_support( 'post-thumbnails' );

add_theme_support( 'title-tag' );

// Add theme support for selective refresh for widgets.
add_theme_support( 'customize-selective-refresh-widgets' );



/**
 * Load breadcrumb_trail File
 */
if (!function_exists('breadcrumb_trail')) {
   require get_stylesheet_directory() . '/library/breadcrumbs/breadcrumbs.php';
}
/**
register_menus - register menus
***/
function scorpio_register_menus() {
  register_nav_menus(
    array(
    	'header-menu' => __( 'Primary Left' ),
      'header-menu-right' => __( 'Primary Right' ),
    	'top-menu' => __( 'Toggle Menu' ),
    	//'footer-menu' => __( 'Footer Menu' )
     )

  );
}
add_action( 'init', 'scorpio_register_menus' );

function theme_scorpio_scripts() {	
  wp_enqueue_style( 'animate', 'https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.1.0/animate.min.css' );
  wp_enqueue_style( 'vendor', get_template_directory_uri() . '/assets/css/vendor/vendor.min.css', array(), null );
	wp_enqueue_style( 'fontawesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css' );
  wp_enqueue_style( 'plugins', get_template_directory_uri() . '/assets/css/plugins/plugins.min.css', array(), null );
  wp_enqueue_style( 'styles', get_template_directory_uri() . '/assets/css/style.min.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_script('vendor', get_template_directory_uri() . '/assets/js/vendor/vendor.min.js', array(), null, true );
  wp_enqueue_script('plugins', get_template_directory_uri() . '/assets/js/plugins/plugins.min.js', array(), null, true );
	wp_enqueue_script('appear', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-appear/0.1/jquery.appear.min.js', null, null, true );
	wp_enqueue_script('TweenMax', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/1.20.3/TweenMax.min.js', null, null, true );
	wp_enqueue_script('effect', get_template_directory_uri() . '/assets/js/effect.js', array(), null, true );	
	wp_enqueue_script('script', get_template_directory_uri() . '/assets/js/main.js', array(), null, true );
}
add_action( 'wp_enqueue_scripts', 'theme_scorpio_scripts' );

/****
widgets_init - register widgets
****/
function scorpio_widgets_init() {
	// main sidebar
	register_sidebar (array(
		'name'          => __('Sidebar','rm'),
		'id'            => "sidebar-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<div class="widget-title"><h3 class="widgettitle">',
		'after_title'   => '</h3></div>' )
		);
		// Newsletter widget area
	register_sidebar (array(
		'name'          => __('Shop page Widget Area','scorpio'),
		'id'            => "shop-widget-area",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// first footer widget area
	register_sidebar (array(
		'name'          => __('First Footer Widget Area','scorpio'),
		'id'            => "footer-first-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget footer-widget links-widget footer-list mb-4 %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// second footer widget area
	register_sidebar (array(
		'name'          => __('Second Footer Widget Area','rm'),
		'id'            => "footer-second-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget links-widget footer-list mb-4 %2$s">',
		'after_widget'  => '</div>',
    'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
	// third footer widget area
	register_sidebar (array(
		'name'          => __('Third Footer Widget Area','rm'),
		'id'            => "footer-third-widget-area",
		'before_widget' => '<div id="%1$s" class="widget footer-widget address mb-4 %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="mb-3">',
		'after_title'   => '</h4>' )
		);
    // fourth footer widget area  	
}
add_action('init', 'scorpio_widgets_init');


function scorpio_sanitize_dropdown_pages( $page_id, $setting ) {
  // Ensure $input is an absolute integer.
  $page_id = absint( $page_id );
  // If $page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

function scorpio_customize_register( $wp_customize ) {
	require_once get_stylesheet_directory() . '/dropdown-category.php';

	//topbar section panel
	$wp_customize->add_panel( 'mytheme_top_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Topbar Setting', 'mytheme' ),
	    'description' => __( 'Add setting of topbar.', 'mytheme' ),
	) );
	//contact detail section
	$wp_customize->add_section('mytheme_contact_section',array(
		'title'	=> __('Contact details','mytheme'),
		'description'=> __('This section will add contact details of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));
	//phone number
	$wp_customize->add_setting('mytheme_phone_num',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_phone_num',array(
		'label'	=> __('Phone Number','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_phone_num',
		'type'=> 'text'
	));
	//email
	$wp_customize->add_setting('mytheme_email_id',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_email_id',array(
		'label'	=> __('Email','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_email_id',
		'type'=> 'text'
	));
	//open hours
	$wp_customize->add_setting('mytheme_open_hours',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_open_hours',array(
		'label'	=> __('Open Time','mytheme'),
		'section'=> 'mytheme_contact_section',
		'setting'=> 'mytheme_open_hours',
		'type'=> 'text'
	));


	//social media section
	$wp_customize->add_section('mytheme_social_section',array(
		'title'	=> __('Social Media links','mytheme'),
		'description'=> __('This section will add social media links of the site.','mytheme'),
		'panel' => 'mytheme_top_sec',
	));

	//Facebook
	$wp_customize->add_setting('mytheme_facebook_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_facebook_link',array(
		'label'	=> __('Facebook','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_facebook_link',
		'type'=> 'text'
	));
	//Twitter
	$wp_customize->add_setting('mytheme_twitter_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_twitter_link',array(
		'label'	=> __('Twitter','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_twitter_link',
		'type'=> 'text'
	));
	//instagram
	$wp_customize->add_setting('mytheme_instagram_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_instagram_link',array(
		'label'	=> __('Instagram','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_instagram_link',
		'type'=> 'text'
	));
	//pinterest
	$wp_customize->add_setting('mytheme_pinterest_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_pinterest_link',array(
		'label'	=> __('Pinterest','mytheme'),
		'section'=> 'mytheme_social_section',
		'setting'=> 'mytheme_pinterest_link',
		'type'=> 'text'
	));


	//theme section panel
	$wp_customize->add_panel( 'mytheme_home_sec', array(
	    'priority' => 100,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Home Page Sections Setting', 'mytheme' ),
	    'description' => __( 'Add setting of home page sections.', 'mytheme' ),
	) );

	//Features section
	$wp_customize->add_section('mytheme_features_section1',array(
		'title'	=> __('Features','mytheme'),
		'description'=> __('This section will display Feature Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));

// Features section pages
	for ( $count = 1; $count <= 4; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features1' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features1' . $count, array(
			'label'    => __( 'Select Feature page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section1',
			'type'     => 'dropdown-pages'
		));
	}


	//home about section
	$wp_customize->add_section('mytheme_about_section',array(
		'title'	=> __('About Section','mytheme'),
		'description'=> __('This section will display Welcome Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
//section title
	$wp_customize->add_setting('mytheme_about_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_about_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_title',
		'type'=> 'text'
	));
//section subtitle
	/* $wp_customize->add_setting('mytheme_about_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_about_section_subtitle',array(
		'label'	=> __('Section Sub Title','mytheme'),
		'section'=> 'mytheme_about_section',
		'setting'=> 'mytheme_about_section_subtitle',
		'type'=> 'text'
	)); */
	//about section page
	$wp_customize->add_setting( 'mytheme_about', array(
			'default'           => '',
			'sanitize_callback' => 'scorpio_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'mytheme_about', array(
			'label'    => __( 'Select About content Page', 'mytheme' ),
			'section'  => 'mytheme_about_section',
			'type'     => 'dropdown-pages'
		));


		//Services section
	$wp_customize->add_section('mytheme_features_section2',array(
		'title'	=> __('Services','mytheme'),
		'description'=> __('This section will display service Content of the site.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));

// Services section pages
	for ( $count = 1; $count <= 10; $count++ ) {

		$wp_customize->add_setting( 'mytheme_features2' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'absint'
		));
		$wp_customize->add_control( 'mytheme_features2' . $count, array(
			'label'    => __( 'Select service page '. $count, 'mytheme' ),
			'section'  => 'mytheme_features_section2',
			'type'     => 'dropdown-pages'
		));
	}

		//home testimonials section
	$wp_customize->add_section('mytheme_testimonials_section',array(
		'title'	=> __('Testimonials Section','mytheme'),
		'description'=> __('This section will display testimonials of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	//section title
	$wp_customize->add_setting('mytheme_testimonials_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_testimonials_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_title',
		'type'=> 'text'
	));
	//section sub-title
	$wp_customize->add_setting('mytheme_testimonials_section_subtitle',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_testimonials_section_subtitle',array(
		'label'	=> __('Section Sub-title','mytheme'),
		'section'=> 'mytheme_testimonials_section',
		'setting'=> 'mytheme_testimonials_section_subtitle',
		'type'=> 'text'
	));

	//home blogs section
	$wp_customize->add_section('mytheme_blogs_section',array(
		'title'	=> __('Blogs Section','mytheme'),
		'description'=> __('This section will display blogs of the page.','mytheme'),
		'panel' => 'mytheme_home_sec',
	));
	//section title
	$wp_customize->add_setting('mytheme_blogs_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('mytheme_blogs_section_title',array(
		'label'	=> __('Section Title','mytheme'),
		'section'=> 'mytheme_blogs_section',
		'setting'=> 'mytheme_blogs_section_title',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'home_blogs_category', array(
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( new My_Dropdown_Category_Control( $wp_customize, 'home_blogs_category', array(
		'section'=> 'mytheme_blogs_section',
		'label'         => esc_html__( 'Blogs posts category', 'mytheme' ),
		'description'   => esc_html__( 'Select the category that the blogs will show posts from. If no category is selected, the blogs will be disabled.'),
		// Uncomment to pass arguments to wp_dropdown_categories()
		//'dropdown_args' => array(
		//	'taxonomy' => 'post_tag',
		//),
	) ) );
}
//add_action('customize_register', 'mytheme_customize_register');


add_post_type_support( 'page', 'excerpt' );


//add_action( 'wp_footer', 'back_to_top' );
    function back_to_top() {
        echo '<a id="totop" href="#"><i class="fa fa-arrow-circle-up" aria-hidden="true" style="font-size: 40px; color: #7b7db1;"></i>
</a>';
    }
    //add_action( 'wp_head', 'back_to_top_style' );
    function back_to_top_style() {
        echo '<style type="text/css">
            #totop {
                position: fixed;
                right: 30px;
                bottom: 30px;
                display: none;
                outline: none;
            }

        </style>';
    }
    //add_action( 'wp_footer', 'custom_script' );
    function custom_script() {
        echo '<script type="text/javascript">
            jQuery(document).ready(function($){
                $(window).scroll(function () {
                    if ( $(this).scrollTop() > 300 )
                        $("#totop").fadeIn();
                    else
                        $("#totop").fadeOut();
                });

                $("#totop").click(function () {
                    $("body,html").animate({ scrollTop: 0 }, 800 );
                    return false;
                });
                $(".menu-item-has-children").addClass("dropdown");
                $(".trail-items").addClass("bread-crumb");
            });
        </script>';
    }
function mytheme_add_woocommerce_support() {

}

//add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );
add_theme_support( 'woocommerce');
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );


    if ( ! function_exists( 'scorpio_shop_cart_total_item' ) ){
		 function scorpio_shop_cart_total_item(){
		   global $woocommerce;
		  ?>
      <a href="#offcanvas-cart" class="offcanvas-toggle">
                                    <span class="cart-count"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span>
                                    <i class="fal fa-shopping-cart"></i>
                                </a>

		  <?php }
		}
if ( ! function_exists( 'scorpio_shop_cart_count_product' ) ){
		  function scorpio_shop_cart_count_product(){

		       scorpio_shop_cart_total_item();

		  }
		}
		//cart view function
		function scorpio_shop_menu_cart_view($cart_view){
			global $woocommerce;
		    $cart_view= scorpio_shop_cart_count_product();
		    return $cart_view;
		}
		add_action( 'scorpio_cart_count','scorpio_shop_menu_cart_view');

    //add_action( 'scorpio_cart_count','scorpio_shop_cart_total_item');

function scorpio_shop_woo_cart_product(){
global $woocommerce;
?>
<div id="scorpio-cart" class="scorpio-cart">
<div class="scorpio-quickcart-dropdown">
<?php
woocommerce_mini_cart();
?>
</div>
</div>
    <?php
}
//add_action( 'scorpio_shop_woo_cart', 'scorpio_shop_woo_cart_product' );
add_filter('woocommerce_add_to_cart_fragments', 'scorpio_shop_add_to_cart_dropdown_fragment');
function scorpio_shop_add_to_cart_dropdown_fragment( $fragments ){
   ob_start();
   ?>
   <div class="widget_shopping_cart_content">
       <?php woocommerce_mini_cart(); ?>

   </div>
   <?php $fragments['div.widget_shopping_cart_content'] = ob_get_clean();

   return $fragments;

}
add_filter('woocommerce_add_to_cart_fragments', 'woocommerce_add_to_cart_count_fragments');
function woocommerce_add_to_cart_count_fragments( $fragments ){
   global $woocommerce;
   $productadd       = wp_kses_data($woocommerce->cart->cart_contents_count);
   ob_start();
   ?>

   <span class="cart-count"><?php echo esc_html( $productadd); ?></span>

 <?php $fragments['span.cart-count'] = ob_get_clean();

   return $fragments;

}
//remove_action( 'woocommerce_widget_shopping_cart_total', 'woocommerce_widget_shopping_cart_subtotal', 10 );
add_action( 'woocommerce_widget_custom_shopping_cart_total', 'woocommerce_widget_custom_shopping_cart_subtotal', 10 );
function woocommerce_widget_custom_shopping_cart_subtotal() {
  ?>
  <div class="sub-total">
  <?php
		echo '<strong>' . esc_html__( 'Subtotal:', 'woocommerce' ) . '</strong> ' . '<span class="amount">'.WC()->cart->get_cart_subtotal().'</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
?>
</div>
<?php
  }
function scorpio_add_to_cart_loop_button(){
  global $product;
  ?>
  <a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" class="product-button hintT-top" data-hint="Add to Cart"><i class="fa fa-shopping-cart"></i></a>

<?php }
//add_action( 'scorpio_cart_loop','scorpio_add_to_cart_loop_button');

if ( ! function_exists( 'scorpio_woocommerce_template_loop_product_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function scorpio_woocommerce_template_loop_product_title() {
		
    ?>
    <div class="d-flex justify-content-center align-items-center">
		<h3 class="<?php echo esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title mb-0 title mb-0' ) ); ?>"><?php echo get_the_title(); ?> <?php $terms = get_the_terms( $product->id, 'pa_size'); 
                    foreach ( $terms as $term ) { ?> <span class="size-label"><?php  echo $term->name; ?></span><?php } ?></h3>
    <?php
		
		//echo '<h3 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title mb-0 theme-blue-text title mb-0' ) ) . '">' . get_the_title() . '</h3>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
?>
<!--a href="#" class="product-tag bg-gray px-3 py-0">single</a-->
</div>
<?php					
                    
  }
}
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title','scorpio_woocommerce_template_loop_product_title', 10);
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_price', 10 );
add_action( 'woocommerce_single_product_summary', 'scorpio_woocommerce_template_size_btn', 10 );
function scorpio_woocommerce_template_size_btn() {
	?>
<div class="size-btns">	
	<?php $terms = get_the_terms( $product->id, 'pa_size'); 
	$link = get_field('single__double_link');	
	 //echo esc_url( $link ); 
		$size_link = $link['url'];
    
                     ?>
	<ul class="mb-3">
		<?php
	foreach ( $terms as $term ) { 
						$size_label=$term->name;
		if($size_label=='Single'){
			//$size_label_link='';
			//$active_class='size_link_active';
			?>
		<li class="size_link_active"><span>Single</span></li>
		<?php
		}else{
			$size_label_link=$size_link;
			?>
		<li><a href="<?php echo $size_label_link; ?>">Single</a></li>
		<?php
		}
		?>
		
		<?php
		if($size_label=='Double'){
			//$size_label_link='';
			//$active_class2='size_link_active';
		?>
		<li class="size_link_active"><span>Double</span></li>
		<?php
		}else{
			$size_label_link=$size_link;
			?>
		<li><a href="<?php echo $size_label_link; ?>">Double</a></li>
		<?php
		}
		?>
		
		<?php
					}
	
	?>
		
		
	</ul>
</div>
<?php
}
add_action( 'woocommerce_shop_loop_item_excerpt','scorpio_woocommerce_template_loop_product_excerpt', 10);
function scorpio_woocommerce_template_loop_product_excerpt() {
  ?>
  <p class="product-excerpt mb-3">
  <?php
  echo get_the_excerpt();
  ?>
</p>
  <?php
}
add_filter( 'woocommerce_output_related_products_args', 'bbloomer_change_number_related_products', 9999 );

function bbloomer_change_number_related_products( $args ) {
 $args['posts_per_page'] = 3; // # of related products
 $args['columns'] = 3; // # of columns per row
 return $args;
}

//remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
//

/**
 * Add a custom product data tab
 */

add_filter( 'woocommerce_product_tabs', 'woo_new_product_tab1' );
function woo_new_product_tab1( $tabs1 ) {
	
	// Adds the new tab
	
	$tabs1['test_tab1'] = array(
		'title' 	=> __( 'Characteristics', 'woocommerce' ),
		'priority' 	=> 5,
		'callback' 	=> 'woo_new_product_tab_content1'
	);

	return $tabs1;

}
function woo_new_product_tab_content1() {
	$term_cat = get_field('characteristics_category');
			if( $term_cat ){
				foreach( $term_cat as $term_cat1 ){
					$term_cat2 = ($term_cat1->slug);
				}				
			}
	if($term_cat2!=''){
		$args = array( 'post_type' => 'characteristics', 'posts_per_page' => -1, 'characteristics_category'=>$term_cat2, 'orderby' => 'menu_order', 'order' => 'ASC', );
	}
	?>
<div class="char-carousel">
<?php
	$the_query = new WP_Query( $args );
	while ($the_query -> have_posts()) : $the_query -> the_post();
			$img_url=wp_get_attachment_url( get_post_thumbnail_id($sdnb_post_id) );
			if($img_url!=''){
				$thumbimage=$img_url;
			}
			else{
				$thumbimage=get_site_url().'/wp-content/uploads/2019/04/logo.png';
			}
	?>
		<div class="char-item mb-5 px-2">
			<div class="charac-img">
			<?php the_post_thumbnail(); ?>
		</div>
		<div class="charac-cont">
			<h3 class="rtin-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
			<p>
				<?php the_content(); ?>
			</p>
		</div>
		</div>

	<?php
 endwhile;
 ?>
</div>
<?php
}

add_filter( 'woocommerce_product_tabs', 'woo_new_product_tab' );
function woo_new_product_tab( $tabs ) {
	
	// Adds the new tab
	
	$tabs['test_tab'] = array(
		'title' 	=> __( 'Product Instructions and Care', 'woocommerce' ),
		'priority' 	=> 20,
		'callback' 	=> 'woo_new_product_tab_content'
	);

	return $tabs;

}

function woo_new_product_tab_content() {

	// The new tab content

	//echo '<h2>Product Instructions and Care</h2>';
	?>
<div class="instruction-dwnld">
	<a href="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/How-to-hang-your-hammock.pdf" class="d-flex align-items-center" target="_blank"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> <span>Manual</span></a>
</div>

<?php
	
}
//tabs order
add_filter( 'woocommerce_product_tabs', 'change_tabs_order' );

function change_tabs_order( $tabs ) {

	$tabs['reviews']['priority'] = 30;
	$tabs['description']['priority'] =10;

	return $tabs;

}
/**
 * Rename product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_rename_tabs', 98 );
function woo_rename_tabs( $tabs ) {

	$tabs['description']['title'] = __( 'Product Information' );		// Rename the description tab
	//$tabs['additional_information']['title'] = __( 'Characteristics' );

	return $tabs;

}
// Change the Product Description Title
add_filter('woocommerce_product_description_heading', 'hjs_product_description_heading');
function hjs_product_description_heading() {
 return __('', 'woocommerce');
}
add_filter( 'gettext', 'misha_no_reviews_heading', 20, 3 );
function misha_no_reviews_heading( $translated, $text, $domain ) {

	if( function_exists( 'is_product' ) && is_product() && $translated == 'Reviews' && $domain == 'woocommerce' ) {
		$translated = 'Ooops... No reviews yet. Please leave one!';
	}

	return $translated;

}
/**
 * Remove product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs ) {

    //unset( $tabs['description'] );      	// Remove the description tab
    //unset( $tabs['reviews'] ); 			// Remove the reviews tab
    unset( $tabs['additional_information'] );  	// Remove the additional information tab

    return $tabs;
}

add_action( 'woocommerce_after_single_product_summary', 'product_chars_sec', 15 );
function product_chars_sec(){
	?>
	<div id="chars" class="chars bg-beige px-lg-5 mx-lg-n5">
		<div class="chars-row mx-lg-5 mb-5">
			<div class="row align-items-end">
			<div class="col-lg-6">
				<div class="char-img ml-lg-n5 mt-lg-n5">
					<img src="https://demo.scorpiotechnologies.us/slack-jack2/wp-content/uploads/2021/09/about-blocks-4_700x.jpg">
				</div>
			</div>
			<div class="col-lg-6">
				<div class="char-cont text-right pr-lg-4 py-5">
					<h4 class="theme-red-text text-uppercase">
						Weathersafe
					</h4>
					<h5 class="theme-blue-text">
						Our signature Hammock can hang outside, rain or shine. 
					</h5>
				</div>
			</div>
		</div>
		</div>
		<div class="char-divider">
			
		</div>
		<div class="chars-row mx-lg-5 mb-5">
			<div class="row align-items-end">
			<div class="col-lg-6 order-lg-2">
				<div class="char-img mr-lg-n5 mt-lg-n5">
					<img src="https://demo.scorpiotechnologies.us/slack-jack2/wp-content/uploads/2021/09/about-blocks-4_700x.jpg">
				</div>
			</div>
			<div class="col-lg-6">
				<div class="char-cont text-right pr-lg-4 py-5">
					<h4 class="theme-red-text text-uppercase">
						Weathersafe
					</h4>
					<h5 class="theme-blue-text">
						Our signature Hammock can hang outside, rain or shine. 
					</h5>
				</div>
			</div>
		</div>
		</div>
		<div class="char-divider">
			
		</div>
		<div class="chars-row mx-lg-5 mb-5">
			<div class="row align-items-end">
			<div class="col-lg-6">
				<div class="char-img ml-lg-n5 mt-lg-n5">
					<img src="https://demo.scorpiotechnologies.us/slack-jack2/wp-content/uploads/2021/09/about-blocks-4_700x.jpg">
				</div>
			</div>
			<div class="col-lg-6">
				<div class="char-cont text-right pr-lg-4 py-5">
					<h4 class="theme-red-text text-uppercase">
						Weathersafe
					</h4>
					<h5 class="theme-blue-text">
						Our signature Hammock can hang outside, rain or shine. 
					</h5>
				</div>
			</div>
		</div>
		</div>
		<div class="char-divider">
			
		</div>
		<div class="chars-row mx-lg-5 mb-5">
			<div class="row align-items-end">
			<div class="col-lg-6 order-lg-2">
				<div class="char-img mr-lg-n5 mt-lg-n5" data-animation="fadeInRight">
					<img src="https://demo.scorpiotechnologies.us/slack-jack2/wp-content/uploads/2021/09/about-blocks-4_700x.jpg">
				</div>
			</div>
			<div class="col-lg-6">
				<div class="char-cont text-right pr-lg-4 py-5">
					<h4 class="theme-red-text text-uppercase" data-animation="fadeInLeft">
						Weathersafe
					</h4>
					<h5 class="theme-blue-text" data-animation="fadeInLeft">
						Our signature Hammock can hang outside, rain or shine. 
					</h5>
				</div>
			</div>
		</div>
		</div>
		<div class="bubbles_wrap"><div class="bubble x1"></div><div class="bubble x2"></div><div class="bubble x3"></div><div class="bubble x4"></div><div class="bubble x5"></div><div class="bubble x6"></div><div class="bubble x7"></div><div class="bubble x8"></div><div class="bubble x9"></div><div class="bubble x10"></div></div>
		</div>
<?php
}

add_action( 'woocommerce_single_product_summary', 'product_features_sec', 55 );
function product_features_sec(){
	?>
	<div class="product-details py-5 mx-lg-n5">	
		<div class="product-details-cont">
			<?php if( have_rows('traditional_hammocks') ): 
	while( have_rows('traditional_hammocks') ): the_row();
	$bed_width = get_sub_field('bed_width1');
	$cloth_length = get_sub_field('cloth_length1');
	$overall_length = get_sub_field('total_length1');
	$required_minimum_distance = get_sub_field('required_minimum_distance1');
	$required_minimum_height = get_sub_field('required_minimum_height1');
	$weight_capacity = get_sub_field('weight_capacity1');
	$country_of_origin = get_sub_field('country_of_origin1');
	$fabric_density = get_sub_field('fabric_density_gm1');
	$material_description = get_sub_field('material_description1');
	$product_weight = get_sub_field('product_weight1');
	if(($cloth_length!='')||($bed_width!='')||($overall_length!='')||($required_minimum_distance!='')||($required_minimum_height!='')||($weight_capacity!='')||($country_of_origin!='')||($fabric_density!='')||($material_description!='')||($product_weight!='')){
	?><h3 class="feature-title px-lg-5 px-3">Product Details</h3>
			<?php }
	if($bed_width!=''){
			?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-2-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed Length : <span><?php echo $bed_width; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($cloth_length!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-1-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed Width : <span><?php echo $cloth_length; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($overall_length!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-3-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Overall Length : <span><?php $overall_length ?></span>
					</div>
				</div>
			</div>
			<?php 
		} if($required_minimum_distance!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/required-minimum-distance.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Required minimum distance : <span><?php echo $required_minimum_distance; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($required_minimum_height!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/required-minimum-height.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Required minimum height : <span><?php echo $required_minimum_height; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($weight_capacity!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/carrying-capacity.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Weight Capacity : <span>120 kilograms</span>
					</div>
				</div>
			</div>
			<?php
		} if($country_of_origin!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/country-of-origin.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Country of origin : <span><?php echo $country_of_origin; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($fabric_density!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/fabric-densituy.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Fabric density : <span><?php echo $fabric_density; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($material_description!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-4.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Material description : <span><?php echo $material_description; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($product_weight!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/product-weight.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Product weight : <span><?php echo $product_weight; ?></span>
					</div>
				</div>
			</div>
			<?php
	}
		endwhile; 
	endif; ?>
			<?php
	//spreader bar hammocks
			?>
			<?php if( have_rows('spreader_bar_hammocks') ): 
	while( have_rows('spreader_bar_hammocks') ): the_row();
	$bed_width2 = get_sub_field('bed_width2');
	$cloth_length2 = get_sub_field('bed_length2');
	$overall_length2 = get_sub_field('total_length2');
	$length_of_the_bar2 = get_sub_field('length_of_the_bar2');
	$required_minimum_distance2 = get_sub_field('required_minimum_distance2');
	$required_minimum_height2 = get_sub_field('required_minimum_height2');
	$weight_capacity2 = get_sub_field('carrying_capacity2');
	$country_of_origin2 = get_sub_field('country_of_origin2');
	$fabric_density2 = get_sub_field('fabric_density_gm2');
	$material_description2 = get_sub_field('material_description');
	$product_weight2 = get_sub_field('product_weight');
	if(($cloth_length2!='')||($bed_width2!='')||($overall_length2!='')||($length_of_the_bar2!='')||($required_minimum_distance2!='')||($required_minimum_height2!='')||($weight_capacity2!='')||($country_of_origin2!='')||($fabric_density2!='')||($material_description2!='')||($product_weight2!='')){
	?><h3 class="feature-title px-lg-5 px-3">Product Details</h3>
			<?php }
	if($bed_width2!=''){
			?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/bed-width.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed Width : <span><?php echo $bed_width2; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($cloth_length2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/bed-length.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed length : <span><?php echo $cloth_length2; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($overall_length2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/total-length.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Total length : <span><?php echo $overall_length2; ?></span>
					</div>
				</div>
			</div>
			<?php 
		} if($length_of_the_bar2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/length-of-bar.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Length of the bar : <span><?php echo $length_of_the_bar2; ?></span>
					</div>
				</div>
			</div>
			<?php 
		} if($required_minimum_distance2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/required-minimum-distance.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Required minimum distance : <span><?php echo $required_minimum_distance2; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($required_minimum_height2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/required-minimum-height.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Required minimum height : <span><?php echo $required_minimum_height2; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($weight_capacity2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/carrying-capacity.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Weight Capacity : <span><?php echo $weight_capacity2; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($country_of_origin2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/country-of-origin.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Country of origin : <span><?php echo $country_of_origin2; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($fabric_density2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/fabric-densituy.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Fabric density : <span><?php echo $fabric_density2; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($material_description2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2018/11/M-Icon-4.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Material description : <span><?php echo $material_description2; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($product_weight2!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/02/product-weight.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Product weight : <span><?php echo $product_weight2; ?></span>
					</div>
				</div>
			</div>
			<?php
	}
		endwhile; 
	endif; ?>
			<?php
	//hammock stand
			?>
			<?php if( have_rows('hammock_stand') ): 
	while( have_rows('hammock_stand') ): the_row();
	$stand_length = get_sub_field('stand_length');
	$stand_height = get_sub_field('stand_height');
	$stand_base_width = get_sub_field('stand_base_width');
	$stand_surface = get_sub_field('stand_surface');
	$stand_carrying_capacity = get_sub_field('stand_carrying_capacity');
	$stand_country_of_origin = get_sub_field('stand_country_of_origin');
	$stand_material_description = get_sub_field('stand_material_description');
	$stand_product_weight = get_sub_field('stand_product_weight');
	if(($stand_length!='')||($stand_height!='')||($stand_base_width!='')||($stand_surface!='')||($stand_carrying_capacity!='')||($stand_country_of_origin!='')||($stand_material_description!='')||($stand_product_weight!='')){
	?><h3 class="feature-title px-lg-5 px-3">Product Details</h3>
			<?php }
	if($stand_length!=''){
			?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-2-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Length : <span><?php echo $stand_length; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($stand_height!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-1-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed length : <span><?php echo $stand_height; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($stand_base_width!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-3-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Total length : <span><?php echo $stand_base_width; ?></span>
					</div>
				</div>
			</div>
			<?php 
		} if($stand_surface!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-3-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Length of the bar : <span><?php echo $stand_surface; ?></span>
					</div>
				</div>
			</div>
			<?php 
		} if($stand_carrying_capacity!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-3-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Required minimum distance : <span><?php echo $stand_carrying_capacity; ?></span>
					</div>
				</div>
			</div>
			<?php
		} if($stand_material_description!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-3-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Required minimum height : <span><?php echo $stand_material_description; ?></span>
					</div>
				</div>
			</div>
			<?php 
	} if($stand_product_weight!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-4.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Weight Capacity : <span><?php echo $stand_product_weight; ?></span>
					</div>
				</div>
			</div>
			<?php
		} 
		endwhile; 
	endif; ?>
			<?php
	//swings
	if( have_rows('swing_details') ): 
	while( have_rows('swing_details') ): the_row();
	$seating_width = get_sub_field('seating_width');
	$seating_height = get_sub_field('seating_height');
	$overall_height = get_sub_field('overall_height');
	$weight_capacity = get_sub_field('weight_capacity');
	if(($seating_width!='')||($seating_height!='')||($overall_height!='')||($weight_capacity!='')){
	?><h3 class="feature-title px-lg-5 px-3">Product Details</h3>
			<?php }
	if($seating_width!=''){
			?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-2-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed Length : <span>193 cms</span>
					</div>
				</div>
			</div>
			<?php 
	} if($seating_height!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-1-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Bed Width : <span>122 cms</span>
					</div>
				</div>
			</div>
			<?php 
	} if($overall_height!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-3-1.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Overall Length : <span>335 cms</span>
					</div>
				</div>
			</div>
			<?php 
	} if($weight_capacity!=''){
		?>
			<div class="row product-details-cont-row px-3 px-lg-5">
				<div class="col-2">
					<div class="product-details-icon">
						<img src="https://www.incahammocks.com/wp-content/uploads/2018/11/M-Icon-4.png">
					</div>
				</div>
				<div class="col-10">
					<div class="product-details-info">
						Weight Capacity : <span>120 kilograms</span>
					</div>
				</div>
			</div>
			<?php }
		endwhile; 
	endif; ?>
		</div>
	</div>
	<?php
}
add_filter( 'get_the_archive_title', function ($title) {
  if ( is_category() ) {
    $title = single_cat_title( '', false );
  } elseif ( is_tag() ) {
    $title = single_tag_title( '', false );
  } elseif ( is_author() ) {
    $title = '<span class="vcard">' . get_the_author() . '</span>' ;
  }
  return $title; 
});

function product_hover_button(){
	?>
<div class="product-hover-button">
	<a href="<?php the_permalink(); ?>">Shop <span><?php the_title(); ?></span></a>
</div>
<?php
}
add_action( 'scorpio_product_hover_button','product_hover_button');
//add_action( 'woocommerce_after_shop_loop_item', 'product_hover_button', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 5 );

remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_single_excerpt', 20 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

?>
