<?php
/**
 * Ajax Registration Module v1.2
 *
 * Ajax Registration Module is a simple and nice Php-Ajax registration page with Ajax validation and easy
 * integration to your existing php application.
 *
 *
 * @copyright     Copyright 2009, Christopher M. Natan
 * @link          http://phpstring.co.cc/phpclasses/modules/ajax-registration-module/
 * @version       $Revision$
 * @modifiedby    $LastChangedBy$
 * @lastmodified  $Date$
 * @email         chris.natan@gmail.com
 * Redistributions of files must retain the above copyright notice.
 */


class Db {

/**
 * Connects  mysql and check if the table is existing
 * @return void
 * @access public
 */
	 
	function execute($query, $query_type)
	{
	global $con;
		if(!empty($query) && !empty($query_type))
		{
			switch(strtolower($query_type))
			{
			case "select":
                $Result = mysqli_query($con, $query) or die("Error in Selection query <br> ".$query."<br>". mysqli_error($con));
				$ResultSet = array();
				if(mysqli_num_rows($Result) > 0)
				{
                    $ResultSet = $Result -> fetch_all(MYSQLI_ASSOC);

			 		return $ResultSet;
				}
				else { return $ResultSet; }
				return true;
            case "selectall":
				$Result = mysqli_query($con, $query) or die("Error in Selection query <br> ".$query."<br>". mysqli_error($con));
				$ResultSet = array();
				if(mysqli_num_rows($Result) > 0)
				{
                    $ResultSet = $Result -> fetch_all(MYSQLI_ASSOC);

			 		return $ResultSet;
				}
				else { return $ResultSet; }
				return true;

			case "update":
				$Result = mysqli_query($con, $query) or die("Error in Updation query <br> ".$query."<br>". mysqli_error());
				if($Result)
				{
					$AffectedNums = mysqli_affected_rows($con);
					return $AffectedNums;
				}
				else return false;
				return true;
			case "norows":
				$Result = mysqli_query($con, $query) or die("Error in No of Rows query <br> ".$query."<br>". mysqli_error());
				if($Result)
				{
					$Totalrows = mysqli_num_rows($Result);
					return $Totalrows;
				}
				else return false;
			return true;
			case "insert":
				$Result = mysqli_query($con, $query) or die("Error in Insertion query <br> ".$query."<br>". mysqli_error($con));
				if($Result)
				{
					$LastInsertedRow = mysqli_insert_id($con);
					return $LastInsertedRow;
				}
				else return false;
			return true;
			case "delete":
				$Result = mysqli_query($con, $query) or die("Error in Deletion query <br> ".$query."<br>". mysqli_error());
				if($Result)
					return true;
				else
					return false;
			}
		}
	}

/**
 * Checks  field names from form and compare them with the table field names
 * @return void
 * @access public
 */
    function check_set() {
     	$field_array    = $this->get_table_fields();
	 	$form_fieldname = explode(",", $_POST['fields'][0]);
	 	for ($i = 0; $i < count($form_fieldname); $i++)  {
	   		$form_field   = $form_fieldname[$i];
	   		if(!strstr($form_field, "#")) {
	     		$this->search_add($form_field, $field_array);
	   		}
	 	}
   }
/**
 * Gets  list of field names from a table
 * @return array
 * @access private
 */
   	function get_table_fields() {
      	$fields  = mysql_list_fields(MYSQL_DATABASE, CWD_MEMBERS);
      	$columns = mysql_num_fields($fields);
      	for ($i = 0; $i < $columns; $i++)  {
	     	$field_array[] = mysql_field_name($fields, $i);
      	}
	  	return $field_array;
   	}
/**
 * Search form field name from an array that contains table field names
 * @return boolean
 * @access private
 */
   	function field_exist($fieldname_to_search, $field_array ) {
     	$search = str_replace('"', "", $fieldname_to_search);
	 	if (!in_array(trim($search), $field_array)) {
	   		return false;
     	}
	 	return true;
  	 }
/**
 * Creates table field in the database for variable $fieldname_to_search
 * @return void
 * @access private
 */
   	function search_add($fieldname_to_search, $field_array ) {
     	$search = str_replace('"', "", $fieldname_to_search);
	 	if (!in_array(trim($search), $field_array)) {
			$result = mysql_query("ALTER TABLE " . MYSQL_DATABASE . "." . USERS_TABLE_NAME .
		          " ADD COLUMN " . str_replace('"', "`", $fieldname_to_search) . " VARCHAR(200) NULL DEFAULT null;");
     	}
   	}
/**
 * Displays  html in the page with mysql error
 * @return void
 * @access private
 */
   	function error() {
    	echo "<div style='width:350;margin:auto;text-align:center;font-family:Arial'>
			     <span style='font-size:15px;color:red'>MYSQL SERVER ERROR : " . mysqli_error() . "</span>
			  </div>";
		echo "<div style='width:350;margin:auto;text-align:center;margin-top:10px;font-family:Arial'>
				 You must edit first the <b>config.php</b> file and input your correct MySQL account, this file
				 is located under this <b>register</b> folder.
				 <p>Note: if  the database TABLE doesn't exist this module will automatically create one.</p>
				 <p>After done editing the config.php try to refresh this page</p>.
			  </div>";
	    die();
   	}
 }
?>
