<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>

	<head>

		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >

		<link rel="profile" href="https://gmpg.org/xfn/11">
<link href="https://fonts.googleapis.com/css?family=Josefin+Sans:400,700%7cLora:400,700,700i&amp;display=swap" rel="stylesheet">
		<?php wp_head(); ?>

	</head>

<body <?php body_class(); ?>>
	<div id="main-wrapper" class="">

	<!--Header section start-->
		<header class="header">
			<div class="header-deafult menu-right d-flex align-items-center">
				<div class="container-fluid px-0">
					<div class="row align-items-center py-2 px-lg-4">
						<div class="col-xl-3 col-lg-3 col-md-2">
							<div class="text-center py-1">
								<?php if ( has_custom_logo() ): ?>
									<?php the_custom_logo(); ?>
										<?php else : ?>
											<h1>
												<a class="site-title text-uppercase" href="<?php echo esc_url( home_url( '/' )); ?>"><?php esc_url(bloginfo('name')); ?></a>
											</h1>
										<?php endif; ?>
							</div>
						</div>
											<!--Menu start-->
						<div class="col-lg-4 offset-lg-1 order-2 order-md-1 justify-content-center">
							<div class="mx-auto">

								<div class="search-box my-2">
									<?php echo do_shortcode('[wpdreams_ajaxsearchlite]'); ?>
								</div>

							</div>
						</div>
						<div class="col-xl-4 col-lg-4 col-md-5 d-flex justify-content-end order-3 order-md-3">

									<!--Cart info Start -->
                                    <div class="cart-info d-flex">
                                        <div class="mini-cart-warp">
                                            <?php if(class_exists( 'WooCommerce' ))
											{
												do_action( 'scorpio_cart_count' );
											} ?>
											<div class="mini-cart-content">
												<?php woocommerce_mini_cart();	?>
											</div>
                                        </div>
                                    </div>
                                    <!--Cart info End -->
						</div>
					</div>
				<!-- Menu Content Start -->
                <div class="header-buttom-nav sticky-nav bg-theme-color">
                    <div class="px-lg-4">
                        <div class="row">
                            <div class="col-md-12 text-left d-none d-lg-block">
                                <div class="d-flex align-items-start justify-content-start">
                                    <!--Main Navigation Start -->
                                    <div class="main-navigation d-none d-lg-block">
                                        <?php
											wp_nav_menu(array(
												'theme_location'    => 'header-menu',
												'container' => false,
												'items_wrap'      => '<ul id="navigation" class="">%3$s</ul>',
												'item_spacing'    => 'preserve',
												'depth'           => 0,
												'add_li_class'  => 'nav-item',
											));
										?>
                                    </div>
                                    <!--Main Navigation End -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Menu Content End -->
				<!-- Header Buttom Start -->
                <div class="header-navigation sticky-nav bg-theme-color d-lg-none">
                    <div class="container position-relative">
                        <div class="row">
                            <!-- Navigation Start -->
                            <div class="col-md-12 col-sm-12">
                                <!--Header Bottom Account Start -->
                                <div class="header_account_area">
                                    <!--Cart info Start -->
                                    <div class="cart-info d-flex">
                                        <div class="mini-cart-warp">
                                            <?php if(class_exists( 'WooCommerce' ))
											{
												do_action( 'scorpio_cart_count' );
											} ?>
											<div class="mini-cart-content">
												<?php woocommerce_mini_cart();	?>
											</div>
                                        </div>
                                    </div>
                                </div>
                                <!--Cart info End -->
                            </div>
                        </div>
                        <!-- mobile menu -->
                        <div class="mobile-menu-area">
                            <div class="mobile-menu">
                                <nav id="mobile-menu-active">
									<?php
											wp_nav_menu(array(
												'theme_location'    => 'header-menu',
												'container' => false,
												'items_wrap'      => '<ul id="navigation" class="menu-overflow">%3$s</ul>',
												'item_spacing'    => 'preserve',
												'depth'           => 0,
												'add_li_class'  => 'nav-item',
											));
										?>
                                </nav>
                            </div>
                        </div>
                        <!-- mobile menu end-->
                    </div>
                </div>
                <!--Header Bottom Account End -->
				
			</div>
		</div>
</header>
			<!--Header section end-->
	<?php if(!(is_front_page()||is_product())){ ?>
		<!-- Breadcrumb Section Start -->
        <div class="breadcrumb-section section bg-image mb-4 py-4" data-bg="./assets/images/bg/bg-title-shop.jpg">
            <div class="container">
                <div class="row">
                    <div class="col">

                        <div class="breadcrumb-title text-center">
                            <h1 class="theme-blue-text"><?php
						if ( is_product_category() ) {
							single_cat_title();
						}
	else if ( is_post_type_archive() ) {
		if ( is_search()){
		woocommerce_page_title();
	} else{
		post_type_archive_title();
		}
	}
	else if(is_archive()){
		the_archive_title();
	}
	else if(is_home()){
		single_post_title();
	}
	elseif(is_page( 96 )){
		echo 'Kloudstore brings you an opportunity to buy software directly From the OEM';
	}

						else{
							the_title();
						}
						?> </h1>
							<?php if ( is_search()||is_product_category()||is_product() ||is_shop() ) {
				  //woocommerce_breadcrumb();
			  }else{ ?>
            <?php //breadcrumb_trail();
}
						?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Breadcrumb Section End -->
		<?php } ?>
